# Include the root terragrunt `root.hcl` configuration. The root configuration contains settings that are common across all
# components and environments, such as how to configure remote state.
include {
  path = find_in_parent_folders("root.hcl")
}

# We override the terraform block source attribute here just for the QA environment to show how you would deploy a
# different version of the module in a specific environment.
terraform {
  # source = "${local.base_source_url}"
  # source = "${local.base_source_url}?ref=v0.4.0"
  source = "../../../../../../flowable-iac-modules-aws//elasticsearch-service"
}

locals {
  # Expose the base source URL so different versions of the module can be deployed in different environments.
  base_source_url = "git@code.flowable.com:flw-lic/flowable-product/flowable-iac/flowable-iac-modules-aws.git//elasticsearch-service"
}

dependency "vpc" {
  config_path = "../../foundation/vpc"
}

inputs = {
  vpc_id              = dependency.vpc.outputs.vpc_id
  vpc_private_subnets = dependency.vpc.outputs.vpc_private_subnets
  vpc_cidr_block      = dependency.vpc.outputs.vpc_cidr_block
  es_cluster_instance_count = 3
  es_cluster_instance_type = "t3.medium.elasticsearch"
}
