# Include the root terragrunt `root.hcl` configuration. The root configuration contains settings that are common across all
# components and environments, such as how to configure remote state.
include {
  path = find_in_parent_folders("root.hcl")
}

# We override the terraform block source attribute here just for the QA environment to show how you would deploy a
# different version of the module in a specific environment.
terraform {
  # source = "${local.base_source_url}"
  # source = "${local.base_source_url}?ref=v0.4.0"
  source = "../../../../../../flowable-iac-modules-aws//rds-oracle"
}

locals {
  # Expose the base source URL so different versions of the module can be deployed in different environments.
  base_source_url = "git@code.flowable.com:flw-lic/flowable-product/flowable-iac/flowable-iac-modules-aws.git//rds-oracle"
}

dependency "vpc" {
  config_path = "../../foundation/vpc"
}

inputs = {
  vpc_id                         = dependency.vpc.outputs.vpc_id
  vpc_cidr_block                 = dependency.vpc.outputs.vpc_cidr_block
  vpc_database_subnet_group_name = dependency.vpc.outputs.vpc_database_subnet_group_name
  flowable_work_db_instance_class = "db.m5.2xlarge"
}
