# Set common variables for the environment. This is automatically pulled in in the root terragrunt root.hcl configuration to
# feed forward to the child modules.
locals {
  # The AWS EKS cluster name
  cluster_name                                    = "flowable-iac-prod"
  
  # The environment suffix is used for resource naming
  env_suffix                                      = "prod"
  
  # The Kubernetes namespace for the Flowable deployments
  namespace                                       = "flowable-iac"
  
  # The Flowable DB authentication secret ARN 
  aws_secret_flowable_db_auth_id                  = "arn:aws:secretsmanager:eu-central-1:485358299920:secret:flowable/prod/flowableDBAuth"
  
  # The Flowable repository (Docker and Helm) authentication secret ARN   
  aws_secret_flowable_repo_auth_id                = "arn:aws:secretsmanager:eu-central-1:485358299920:secret:flowable/prod/flowableRepoAuth"
  
  # The Flowable license file secret ARN   
  aws_secret_flowable_license_id                  = "arn:aws:secretsmanager:eu-central-1:485358299920:secret:flowable/prod/flowableLicense"
}