# Include the root terragrunt `root.hcl` configuration. The root configuration contains settings that are common across all
# components and environments, such as how to configure remote state.
include "root" {
  path = find_in_parent_folders("root.hcl")
  expose = true
}

# We override the terraform block source attribute here just for the QA environment to show how you would deploy a
# different version of the module in a specific environment.
terraform {
  source = "${local.base_source_url}"
  # source = "${local.base_source_url}?ref=v0.4.0"
  # source = "../../../../../../flowable-iac-modules-aws//vpc"
}

locals {
  # Expose the base source URL so different versions of the module can be deployed in different environments.
  base_source_url = "git@code.flowable.com:flw-lic/flowable-product/flowable-iac/flowable-iac-modules-aws.git//vpc"
}

dependencies {
  paths = ["../resource-group"]
}

inputs = {
  vpc_name_prefix      = "${include.root.locals.common_vars.workload}"
  vpc_cidr             = "10.1.0.0/16"
  vpc_public_subnets   = ["10.1.1.0/24", "10.1.2.0/24", "10.1.3.0/24"]
  vpc_private_subnets  = ["10.1.4.0/24", "10.1.5.0/24", "10.1.6.0/24"]
  vpc_database_subnets = ["10.1.7.0/24", "10.1.8.0/24", "10.1.9.0/24"]
}
