/**
  * # AWS - Elastic File Storage
  * 
  * This a Terraform module for creating a resource group on AWS filtering on the `flowable-iac` tag.
  * See the documentation below for additional info on using this module.
  */

# Create a EFS
resource "aws_efs_file_system" "efs" {
  creation_token   = "${var.workload}-efs"
  performance_mode = var.efs_performance_mode
  encrypted        = "true"

  tags = {
    Name = "${var.workload}-efs"
  }
}

# Create a EFS mount target
resource "aws_efs_mount_target" "efs" {
  count           = length(var.efs_subnets)
  file_system_id  = aws_efs_file_system.efs.id
  subnet_id       = element(var.efs_subnets, count.index)
  security_groups = ["${aws_security_group.efs.id}"]
}

resource "aws_security_group" "efs" {
  name_prefix = "flowable-efs"
  vpc_id      = var.vpc_id

  ingress {
    from_port   = 2049
    to_port     = 2049
    protocol    = "tcp"
    cidr_blocks = ["0.0.0.0/0"]
  }

  egress {
    from_port   = 0
    to_port     = 0
    protocol    = "-1"
    cidr_blocks = ["0.0.0.0/0"]
  }

}
