<!-- BEGIN_TF_DOCS -->
# AWS - Amazon Elasticsearch Service

## Requirements

| Name | Version |
|------|---------|
| <a name="requirement_terraform"></a> [terraform](#requirement\_terraform) | >= 1.0.0 |
| <a name="requirement_aws"></a> [aws](#requirement\_aws) | ~> 3.74.0 |

## Providers

| Name | Version |
|------|---------|
| <a name="provider_aws"></a> [aws](#provider\_aws) | ~> 3.74.0 |

## Resources

| Name | Type |
|------|------|
| [aws_elasticsearch_domain.es](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/elasticsearch_domain) | resource |
| [aws_iam_service_linked_role.es](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_service_linked_role) | resource |
| [aws_security_group.es](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/security_group) | resource |
| [aws_availability_zones.available](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/availability_zones) | data source |
| [aws_caller_identity.current](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/caller_identity) | data source |
| [aws_region.current](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/region) | data source |

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| <a name="input_es_domain_name_prefix_override"></a> [es\_domain\_name\_prefix\_override](#input\_es\_domain\_name\_prefix\_override) | Override the Elasticsearch domain name prefix (by default full\_workload variable will be used as a prefix) | `string` | `""` | no |
| <a name="input_full_workload"></a> [full\_workload](#input\_full\_workload) | The full workload name (workload and environment suffix) | `string` | n/a | yes |
| <a name="input_vpc_id"></a> [vpc\_id](#input\_vpc\_id) | The ID of the VPC | `string` | n/a | yes |
| <a name="input_vpc_cidr_block"></a> [vpc\_cidr\_block](#input\_vpc\_cidr\_block) | The CIDR block of the VPC | `string` | n/a | yes |
| <a name="input_vpc_private_subnets"></a> [vpc\_private\_subnets](#input\_vpc\_private\_subnets) | The private subnets of the VPC | `list(string)` | n/a | yes |
| <a name="input_es_enabled"></a> [es\_enabled](#input\_es\_enabled) | Flag wether Elasticsearch is enabled or not | `bool` | n/a | yes |
| <a name="input_es_cluster_instance_count"></a> [es\_cluster\_instance\_count](#input\_es\_cluster\_instance\_count) | The number of instances in this ES cluster | `number` | `3` | no |
| <a name="input_es_cluster_instance_type"></a> [es\_cluster\_instance\_type](#input\_es\_cluster\_instance\_type) | The instance type in this ES cluster | `string` | `"t3.medium.elasticsearch"` | no |

## Outputs

| Name | Description |
|------|-------------|
| <a name="output_elk_endpoint"></a> [elk\_endpoint](#output\_elk\_endpoint) | n/a |
<!-- END_TF_DOCS -->