<!-- BEGIN_TF_DOCS -->
# AWS - Flowable App

This a Terraform module for deploying Flowable services using the [Flowable Helm Chart](https://code.flowable.com/flw-lic/flowable-product/flowable-iac/flowable-iac-helm)
on Elastic Kubernetes Service (EKS).
See the documentation below for additional info on using this module.

## Requirements

| Name | Version |
|------|---------|
| <a name="requirement_terraform"></a> [terraform](#requirement\_terraform) | >= 1.0.0 |
| <a name="requirement_aws"></a> [aws](#requirement\_aws) | ~> 3.74.0 |
| <a name="requirement_helm"></a> [helm](#requirement\_helm) | ~> 2.4.1 |
| <a name="requirement_kubernetes"></a> [kubernetes](#requirement\_kubernetes) | ~> 2.7.1 |

## Providers

| Name | Version |
|------|---------|
| <a name="provider_aws"></a> [aws](#provider\_aws) | ~> 3.74.0 |
| <a name="provider_helm"></a> [helm](#provider\_helm) | ~> 2.4.1 |

## Resources

| Name | Type |
|------|------|
| [helm_release.flowable](https://registry.terraform.io/providers/hashicorp/helm/latest/docs/resources/release) | resource |
| [aws_eks_cluster.eks](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/eks_cluster) | data source |
| [aws_eks_cluster_auth.eks](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/eks_cluster_auth) | data source |
| [aws_secretsmanager_secret_version.flowable_db_auth](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/secretsmanager_secret_version) | data source |
| [aws_secretsmanager_secret_version.flowable_repo_auth](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/secretsmanager_secret_version) | data source |

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| <a name="input_cluster_name"></a> [cluster\_name](#input\_cluster\_name) | Name of the Kubernetes cluster | `string` | n/a | yes |
| <a name="input_aws_secret_flowable_repo_auth_id"></a> [aws\_secret\_flowable\_repo\_auth\_id](#input\_aws\_secret\_flowable\_repo\_auth\_id) | ID (ARN) of the AWS secret that will be used to fetch the Flowable repository authentication related credentials and settings | `string` | n/a | yes |
| <a name="input_aws_secret_flowable_db_auth_id"></a> [aws\_secret\_flowable\_db\_auth\_id](#input\_aws\_secret\_flowable\_db\_auth\_id) | ID (ARN) of the AWS secret that will be used to fetch the Flowable DB authentication related credentials and settings | `string` | n/a | yes |
| <a name="input_release_name"></a> [release\_name](#input\_release\_name) | Name of the Helm release | `string` | n/a | yes |
| <a name="input_release_namespace"></a> [release\_namespace](#input\_release\_namespace) | Namespace of the  Helm release | `string` | n/a | yes |
| <a name="input_chart_name"></a> [chart\_name](#input\_chart\_name) | Name of the Flowable Helm chart | `string` | n/a | yes |
| <a name="input_chart_version"></a> [chart\_version](#input\_chart\_version) | Version of the Flowable Helm chart | `string` | n/a | yes |
| <a name="input_create_namespace"></a> [create\_namespace](#input\_create\_namespace) | Create release namespace | `string` | `"true"` | no |
| <a name="input_helm_repo_url"></a> [helm\_repo\_url](#input\_helm\_repo\_url) | Flowable Helm repository url | `string` | `"https://artifacts.flowable.com/artifactory/helm-product"` | no |
| <a name="input_values"></a> [values](#input\_values) | The Flowalbe Helm chart values in (yaml format). See https://code.flowable.com/flw-lic/flowable-product/flowable-iac/flowable-iac-helm for more information | `string` | n/a | yes |

## Outputs

No outputs.
<!-- END_TF_DOCS -->