/**
  * # AWS - EKS Cluster
  * 
  * This a Terraform module for creating EKS Cluster on AWS.
  * See the documentation below for additional info on using this module.
  */

provider "kubernetes" {
  host                   = data.aws_eks_cluster.cluster.endpoint
  cluster_ca_certificate = base64decode(data.aws_eks_cluster.cluster.certificate_authority.0.data)
  token                  = data.aws_eks_cluster_auth.cluster.token
}

provider "helm" {
  kubernetes {
    host                   = data.aws_eks_cluster.cluster.endpoint
    cluster_ca_certificate = base64decode(data.aws_eks_cluster.cluster.certificate_authority[0].data)
    token                  = data.aws_eks_cluster_auth.cluster.token
  }
}

module "eks" {
  source          = "terraform-aws-modules/eks/aws"
  version         = "~> 17.24.0"
  cluster_name    = var.cluster_name
  cluster_version = "1.21"
  subnets         = var.vpc_private_subnets

  vpc_id = var.vpc_id

  enable_irsa = true

  cluster_endpoint_private_access = true
  cluster_endpoint_public_access  = true

  map_roles = var.additional_map_roles

  worker_groups = [
    {
      name                 = "worker-group-1"
      instance_type        = var.worker_group_instance_type
      asg_max_size         = var.worker_group_max_size
      asg_min_size         = var.worker_group_min_size
      asg_desired_capacity = var.worker_group_desired_capacity
      key_name             = aws_key_pair.nodes.key_name
      # additional_security_group_ids = [aws_security_group.worker_group_mgmt_one.id]
    }
  ]
}

data "aws_eks_cluster" "cluster" {
  name = module.eks.cluster_id
}

data "aws_eks_cluster_auth" "cluster" {
  name = module.eks.cluster_id
}

resource "tls_private_key" "nodes" {
  algorithm = "RSA"
}

resource "aws_key_pair" "nodes" {
  key_name   = "${var.cluster_name}-nodes"
  public_key = tls_private_key.nodes.public_key_openssh
}
