variable "namespace" {
  description = "Name of the namespace where the resources will reside"
  type = string
}

variable "cluster_name" {
  description = "Then name of kubernetes cluster"
  type = string
}

variable "flowable_docker_registry_server" {
  description = "The Flowable docker registry server"
  default     = "artifacts.flowable.com"
  type = string
}

variable "flowable_repo_username" {
  description = "The Flowable docker registry username which can be used to override `keyvault_secret_name_flowable_repo_username`"
  default = ""
  type = string
}

variable "flowable_repo_password" {
  description = "The Flowable docker registry password which can be used to override `keyvault_secret_name_flowable_repo_password`"
  default = ""
  sensitive   = true
  type = string
}

variable "flowable_db_username" {
  description = "The Flowable docker registry username which can be used to override `keyvault_secret_name_flowable_db_username`"
  default = ""
  type = string
}

variable "flowable_db_password" {
  description = "The Flowable docker registry password which can be used to override `keyvault_secret_name_flowable_db_password`"
  default = ""
  sensitive   = true
  type = string
}

variable "secret_name_docker_auth" {
  description = "Name of the Kubernetes secret which holds the Docker registry authentication"
  type = string
}

variable "secret_name_flowable_license" {
  description = "Name of the Kubernetes secret that will be created to store the Flowable license"
  type = string
}

variable "aws_secret_flowable_repo_auth_id" {
  description = "ID (ARN) of the AWS secret that will be used to fetch the Flowable repository authentication related credentials and settings"
  type = string
}

variable "aws_secret_flowable_db_auth_id" {
  description = "ID (ARN) of the AWS secret that will be used to fetch the Flowable db authentication related credentials and settings"
  type = string
}

variable "aws_secret_flowable_repo_username_key" {
  description = "Name of the key in the AWS secret which holds the Flowable repository username"
  type = string
}

variable "aws_secret_flowable_repo_password_key" {
  description = "Name of the key in the AWS secret which holds the Flowable repository password"
  type = string
}

variable "aws_secret_flowable_license_id" {
  description = "ID (ARN) of the AWS secret that will be used to fetch the Flowable license"
  type = string
}

variable "aws_secret_flowable_license_key" {
  description = "Name of the key in the AWS secret which holds the Flowable license"
  type = string
}

variable "efs_file_system_id" {
  description = "The ID of the EFS file system used for creating a storage class"
  type = string
}

variable "cluster_oidc_issuer_arn" {
  description =  "Issuer ARN of the cluster OpenID Connect"
  type = string
}

variable "cluster_oidc_issuer_url" {
  description =  "Issuer URL of the cluster OpenID Connect"
  type = string
}
