<!-- BEGIN_TF_DOCS -->
# AWS - RDS Oracle Enterprise

This a Terraform module for creating a RDS Oracle Enterprise on AWS.
See the documentation below for additional info on using this module.

## Requirements

| Name | Version |
|------|---------|
| <a name="requirement_terraform"></a> [terraform](#requirement\_terraform) | >= 1.0.0 |
| <a name="requirement_aws"></a> [aws](#requirement\_aws) | ~> 3.74.0 |
| <a name="requirement_kubernetes"></a> [kubernetes](#requirement\_kubernetes) | ~> 2.7.1 |

## Providers

| Name | Version |
|------|---------|
| <a name="provider_aws"></a> [aws](#provider\_aws) | ~> 3.74.0 |

## Resources

| Name | Type |
|------|------|
| [aws_db_instance.flowable_control_db](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/db_instance) | resource |
| [aws_db_instance.flowable_design_db](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/db_instance) | resource |
| [aws_db_instance.flowable_engage_db](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/db_instance) | resource |
| [aws_db_instance.flowable_work_db](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/db_instance) | resource |
| [aws_db_parameter_group.flowable_db_oe](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/db_parameter_group) | resource |
| [aws_security_group.database](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/security_group) | resource |
| [aws_secretsmanager_secret_version.flowable_db_auth](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/secretsmanager_secret_version) | data source |

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| <a name="input_name_prefix_override"></a> [name\_prefix\_override](#input\_name\_prefix\_override) | Override the DB name prefixes (by default full\_workload variable will be used as a prefix) | `string` | `""` | no |
| <a name="input_full_workload"></a> [full\_workload](#input\_full\_workload) | The full workload name (workload and environment suffix) | `string` | n/a | yes |
| <a name="input_vpc_id"></a> [vpc\_id](#input\_vpc\_id) | The ID of the VPC | `string` | n/a | yes |
| <a name="input_vpc_cidr_block"></a> [vpc\_cidr\_block](#input\_vpc\_cidr\_block) | The VPC CIRD block | `string` | n/a | yes |
| <a name="input_vpc_database_subnet_group_name"></a> [vpc\_database\_subnet\_group\_name](#input\_vpc\_database\_subnet\_group\_name) | The VPC database subnet group name | `string` | n/a | yes |
| <a name="input_env_suffix"></a> [env\_suffix](#input\_env\_suffix) | The environment suffix that will be used when creating resources | `string` | n/a | yes |
| <a name="input_aws_secret_flowable_db_auth_id"></a> [aws\_secret\_flowable\_db\_auth\_id](#input\_aws\_secret\_flowable\_db\_auth\_id) | ID (ARN) of the AWS secret that will be used to fetch the Flowable DB authentication related credentials and settings | `string` | n/a | yes |
| <a name="input_flowable_control_db_instance_class"></a> [flowable\_control\_db\_instance\_class](#input\_flowable\_control\_db\_instance\_class) | The RDS instance type class for the Flowable Control DB | `string` | `"db.t3.medium"` | no |
| <a name="input_flowable_control_db_allocated_storage"></a> [flowable\_control\_db\_allocated\_storage](#input\_flowable\_control\_db\_allocated\_storage) | The allocated storage in Gb for the Flowable Control DB | `number` | `10` | no |
| <a name="input_flowable_design_db_instance_class"></a> [flowable\_design\_db\_instance\_class](#input\_flowable\_design\_db\_instance\_class) | The RDS instance type class for the Flowable Design DB | `string` | `"db.t3.medium"` | no |
| <a name="input_flowable_design_db_allocated_storage"></a> [flowable\_design\_db\_allocated\_storage](#input\_flowable\_design\_db\_allocated\_storage) | The allocated storage in Gb for the Flowable Design DB | `number` | `10` | no |
| <a name="input_flowable_work_db_instance_class"></a> [flowable\_work\_db\_instance\_class](#input\_flowable\_work\_db\_instance\_class) | The RDS instance type class for the Flowable Work DB | `string` | `"db.m5.large"` | no |
| <a name="input_flowable_work_db_allocated_storage"></a> [flowable\_work\_db\_allocated\_storage](#input\_flowable\_work\_db\_allocated\_storage) | The allocated storage in Gb for the Flowable Work DB | `number` | `20` | no |
| <a name="input_flowable_engage_db_instance_class"></a> [flowable\_engage\_db\_instance\_class](#input\_flowable\_engage\_db\_instance\_class) | The RDS instance type class for the Flowable Engage DB | `string` | `"db.m5.large"` | no |
| <a name="input_flowable_engage_db_allocated_storage"></a> [flowable\_engage\_db\_allocated\_storage](#input\_flowable\_engage\_db\_allocated\_storage) | The allocated storage in Gb for the Flowable Engage DB | `number` | `20` | no |
| <a name="input_flowable_control_enabled"></a> [flowable\_control\_enabled](#input\_flowable\_control\_enabled) | Enable the Flowable Control DB | `bool` | n/a | yes |
| <a name="input_flowable_design_enabled"></a> [flowable\_design\_enabled](#input\_flowable\_design\_enabled) | Enable the Flowable Design DB | `bool` | n/a | yes |
| <a name="input_flowable_work_enabled"></a> [flowable\_work\_enabled](#input\_flowable\_work\_enabled) | Enable the Flowable Work DB | `bool` | n/a | yes |
| <a name="input_flowable_engage_enabled"></a> [flowable\_engage\_enabled](#input\_flowable\_engage\_enabled) | Enable the Flowable Engage DB | `bool` | n/a | yes |

## Outputs

| Name | Description |
|------|-------------|
| <a name="output_db_control_endpoint"></a> [db\_control\_endpoint](#output\_db\_control\_endpoint) | The endpoint of the Flowable Control DB |
| <a name="output_db_control_name"></a> [db\_control\_name](#output\_db\_control\_name) | The name of the Flowable Control DB |
| <a name="output_db_design_name"></a> [db\_design\_name](#output\_db\_design\_name) | The name of the Flowable Design DB |
| <a name="output_db_design_endpoint"></a> [db\_design\_endpoint](#output\_db\_design\_endpoint) | The endpoint of the Flowable Design DB |
| <a name="output_db_work_name"></a> [db\_work\_name](#output\_db\_work\_name) | The name of the Flowable Work DB |
| <a name="output_db_work_endpoint"></a> [db\_work\_endpoint](#output\_db\_work\_endpoint) | The endpoint of the Flowable Work DB |
| <a name="output_db_engage_name"></a> [db\_engage\_name](#output\_db\_engage\_name) | The name of the Flowable Engage DB |
| <a name="output_db_engage_endpoint"></a> [db\_engage\_endpoint](#output\_db\_engage\_endpoint) | The endpoint of the Flowable Engage DB |
<!-- END_TF_DOCS -->