# Flowable Infrastructure as Code - Deployments - AWS

This repository contains the [Terragrunt](https://github.com/gruntwork-io/terragrunt) configuration files that, along with the [Terraform](https://www.terraform.io/) modules in [Flowable Infrastructure as Code - Modules](https://code.flowable.com/flw-lic/flowable-product/flowable-iac/flowable-iac-modules), can be used to deploy a complete infrastructure running Flowable on various cloud platforms.

## How do you deploy the infrastructure in this repo?

### Pre-requisites

1. Install [Terraform](https://www.terraform.io/) version `v1.0.0` or newer and
   [Terragrunt](https://github.com/gruntwork-io/terragrunt) version `v0.32.0` or newer.
2. Follow the cloud provider specific instructions in the sub folders.


## How is the code in this repo organized?

The code in this repo uses the following folder hierarchy:

```
cloud provider
 └ account
  └ _global
  └ region
     └ _global
     └ environment
        └ resource
```

Where:

* **Cloud provider**: At the top level are each of the cloud providers , such as `aws`, `gcp`, `azure`,
  etc. If you have everything deployed in a single AWS account, there will just be a single folder at the root (e.g.
  `aws`).

* **Account**: Within each of your cloud provider there are the provider  accounts, such as `stage-account`, `prod-account`, `mgmt-account`,
  etc. If you have everything deployed in a single AWS account, there will just be a single folder at the root (e.g.
  `main-account`).

* **Region**: Within each account, there will be one or more [AWS
  regions](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html), such as
  `us-east-1`, `eu-west-1`, and `ap-southeast-2`, where you've deployed resources. There may also be a `_global`
  folder that defines resources that are available across all the AWS regions in this account, such as IAM users,
  Route 53 hosted zones, and CloudTrail.

* **Environment**: Within each region, there will be one or more "environments", such as `qa`, `stage`, etc. Typically,
  an environment will correspond to a single [AWS Virtual Private Cloud (VPC)](https://aws.amazon.com/vpc/), which
  isolates that environment from everything else in that AWS account. There may also be a `_global` folder
  that defines resources that are available across all the environments in this AWS region, such as Route 53 A records,
  SNS topics, and ECR repos.

  ## Creating and using root (account) level variables

In the situation where you have multiple AWS accounts or regions, you often have to pass common variables down to each
of your modules. Rather than copy/pasting the same variables into each `terragrunt.hcl` file, in every region, and in
every environment, you can inherit them from the `inputs` defined in the root `root.hcl` file.