# Set common variables for the app. This is automatically pulled in in the root terragrunt root.hcl configuration to
# feed forward to the child modules.
locals {
  # The role ARN that will be used to deploy the app layer
  tf_assume_role_arn = "arn:aws:iam::569661360756:role/flowable/DevOpsAdminRole"
  
  # enable Flowable components
  # this will also affect DB instance creation / deletion
  flowable_control_enabled = false
  flowable_design_enabled  = true
  flowable_work_enabled    = true
  flowable_engage_enabled  = false

  # General Elasticsearch settings
  es_enabled          = false
  es_cluster_name     = "flowable-es"

  # General Database settings
  db_service_name     = "flowable-db"
  db_namespace_suffix = "db"
  db_name             = "flowable"
  db_storage_class    = "default"

  # external_domain = "flowable.com"
}
