# Include the root terragrunt `root.hcl` configuration. The root configuration contains settings that are common across all
# components and environments, such as how to configure remote state.
include {
  path = find_in_parent_folders("root.hcl")
}

terraform {
  # source = "${local.base_source_url}"
  # source = "${local.base_source_url}?ref=v0.4.0"
  source = "../../../../../../flowable-iac-modules-aws//efs"
}

locals {
  # Expose the base source URL so different versions of the module can be deployed in different environments.
  base_source_url = "git@code.flowable.com:flw-lic/flowable-product/flowable-iac/flowable-iac-modules-aws.git//efs"
}

dependency "vpc"{
  config_path = "../vpc"
}

inputs = {
  vpc_id                          = dependency.vpc.outputs.vpc_id
  efs_subnets                     = dependency.vpc.outputs.vpc_private_subnets
}
  