/**
  * # AWS - Flowable App
  * 
  * This a Terraform module for deploying Flowable services using the [Flowable Helm Chart](https://code.flowable.com/flw-lic/flowable-product/flowable-iac/flowable-iac-helm) 
  * on Elastic Kubernetes Service (EKS).
  * See the documentation below for additional info on using this module.
  */

locals {
  flowable_repo_username = jsondecode(data.aws_secretsmanager_secret_version.flowable_repo_auth.secret_string)["flowable_repo_username"]
  flowable_repo_password = jsondecode(data.aws_secretsmanager_secret_version.flowable_repo_auth.secret_string)["flowable_repo_password"]
}

provider "kubernetes" {
  host                   = data.aws_eks_cluster.eks.endpoint
  cluster_ca_certificate = base64decode(data.aws_eks_cluster.eks.certificate_authority[0].data)
  token                  = data.aws_eks_cluster_auth.eks.token
}

provider "helm" {
  kubernetes {
    host                   = data.aws_eks_cluster.eks.endpoint
    cluster_ca_certificate = base64decode(data.aws_eks_cluster.eks.certificate_authority[0].data)
    token                  = data.aws_eks_cluster_auth.eks.token
  }
}

data "aws_eks_cluster" "eks" {
  name = var.cluster_name
}

data "aws_eks_cluster_auth" "eks" {
  name = var.cluster_name
}

data "aws_secretsmanager_secret_version" "flowable_repo_auth" {
  secret_id = var.aws_secret_flowable_repo_auth_id
}

data "aws_secretsmanager_secret_version" "flowable_db_auth" {
  secret_id = var.aws_secret_flowable_db_auth_id
}

resource "helm_release" "flowable" {
  name                = var.release_name
  namespace           = var.release_namespace
  create_namespace    = var.create_namespace
  repository          = var.helm_repo_url
  repository_username = local.flowable_repo_username
  repository_password = local.flowable_repo_password
  chart               = var.chart_name
  version             = var.chart_version
  verify              = false
  timeout             = 900
  values = [
    "${var.values}"
  ]
}
