variable "cluster_name" {
  description = "Name of the cluster"
  type        = string
}

variable "vpc_id" {
  description = "The ID of the VPC"
  type        = string
}

variable "worker_group_instance_type" {
  description = "The EC2 instance type used for the nodes"
  type = string
}

variable "worker_group_desired_capacity" {
  description = "The desired node capacity for the worker group"
  type = string
}

variable "worker_group_max_size" {
  description = "The maximum node capacity for the worker group"
  type = string
  default = ""
}

variable "worker_group_min_size" {
  description = "The minimum node capacity for the worker group"
  type = string
  default = ""
}

# variable "sg_worker_group_mgmt_one_id" {
#   description = "The security group worker group mgmt one ID"
#   type        = string
# }

# variable "sg_worker_group_mgmt_two_id" {
#   description = "The security group worker group mgmt two ID"
#   type        = string
# }

variable "vpc_private_subnets" {
  description = "The private subnets of the VPC"
  type        = list(string)
}

variable "additional_map_roles" {
  description = "Additional IAM roles to add to the aws-auth configmap."
  type = list(object({
    rolearn  = string
    username = string
    groups   = list(string)
  }))
  default = []
}
