variable "name_prefix_override" {
  description = "Override the DB name prefixes (by default full_workload variable will be used as a prefix)"
  type        = string
  default     = ""
}

variable "full_workload" {
  description = "The full workload name (workload and environment suffix)"
  type        = string
}

variable "vpc_id" {
  description = "The ID of the VPC"
  type        = string
}

variable "vpc_cidr_block" {
  description = "The VPC CIRD block"
  type        = string
}

variable "vpc_database_subnet_group_name" {
  description = "The VPC database subnet group name"
  type        = string
}

variable "env_suffix" {
  description = "The environment suffix that will be used when creating resources"
  type        = string
}

variable "aws_secret_flowable_db_auth_id" {
  description = "ID (ARN) of the AWS secret that will be used to fetch the Flowable DB authentication related credentials and settings"
  type        = string
}

variable "db_engine_version" {
  description = "The PostgreSQL engine version to use"
  type        = string
}

variable "db_skip_final_snapshot" {
  description = "Determines whether a final DB snapshot is created before the DB instance is deleted"
  default     = "false"
  type        = string
}

variable "db_apply_immediately" {
  description = "Specifies whether any database modifications are applied immediately, or during the next maintenance window"
  default     = "false"  
  type        = string
}

variable "db_auto_minor_version_upgrade" {
  description = "Indicates that minor engine upgrades will be applied automatically to the DB instance during the maintenance window."
  default     = "false"  
  type        = string
}

variable "flowable_control_db_instance_class" {
  description = "The RDS instance type class for the Flowable Control DB"
  type        = string
  default     = "db.t3.micro"
}

variable "flowable_control_db_allocated_storage" {
  description = "The allocated storage in Gb for the Flowable Control DB"
  type        = number
  default     = 5
}

variable "flowable_design_db_instance_class" {
  description = "The RDS instance type class for the Flowable Design DB"
  type        = string
  default     = "db.t3.micro"
}

variable "flowable_design_db_allocated_storage" {
  description = "The allocated storage in Gb for the Flowable Design DB"
  type        = number
  default     = 5
}

variable "flowable_work_db_instance_class" {
  description = "The RDS instance type class for the Flowable Work DB"
  type        = string
  default     = "db.m5.large"
}

variable "flowable_work_db_allocated_storage" {
  description = "The allocated storage in Gb for the Flowable Work DB"
  type        = number
  default     = 10
}

variable "flowable_engage_db_instance_class" {
  description = "The RDS instance type class for the Flowable Engage DB"
  type        = string
  default     = "db.m5.large"
}

variable "flowable_engage_db_allocated_storage" {
  description = "The allocated storage in Gb for the Flowable Engage DB"
  type        = number
  default     = 10
}

variable "flowable_control_enabled" {
  description = "Enable the Flowable Control DB"
  type        = bool
}

variable "flowable_design_enabled" {
  description = "Enable the Flowable Design DB"
  type        = bool
}

variable "flowable_work_enabled" {
  description = "Enable the Flowable Work DB"
  type        = bool
}

variable "flowable_engage_enabled" {
  description = "Enable the Flowable Engage DB"
  type        = bool
}
