variable "vpc_name_override" {
  description = "Override the VPC name (by default full_workload variable will be used as a prefix)"
  type = string
  default = ""
}

variable "full_workload" {
  description = "The full workload name (workload and environment suffix)"
  type = string
}

variable "cluster_name" {
  description = "Name of the Kubernetes cluster"
  type = string
}

variable "vpc_cidr" {
  description = "The CIDR of the VPC"
  type = string
}

variable "vpc_public_subnets" {
  description = "The CIDR of the public subnets"
  type = list(string)
}

variable "vpc_private_subnets" {
  description = "The CIDR of the private subnets"
  type = list(string)
}

variable "vpc_database_subnets" {
  description = "The CIDR of the database subnets"
  type = list(string)
}